implementation module timerdevice


import	StdInt, StdBool, StdFunc, StdEnum, StdList, StdTuple
from	StdPSt	import	accPIO, appPIO
import	timerevent, timeraccess, timerdefaccess, devicefunctions, iostate, receiverhandle, commondef


timerdeviceFatalError :: String String -> .x
timerdeviceFatalError function error
	= FatalError function "timerdevice" error

TimerFunctions :: DeviceFunctions i o .l .p
TimerFunctions
	= {	dShow	= id
	  ,	dHide	= id
	  ,	dEvent	= timerEvent
	  ,	dDoIO	= timerIO
	  ,	dOpen	= IOStSetDevice (TimerSystemState {tSysIds=[sysId idnr\\idnr<-[0..]],tTimers=[]})	//PA: changed
	  ,	dClose	= timerClose
	  }

timerClose :: !(IOSt .l .p) -> IOSt .l .p
timerClose ioState
	# (rt,ioState)		= IOStGetReceiverTable ioState
	# (tt,ioState)		= IOStGetTimerTable ioState
	# (timers,ioState)	= IOStGetDevice TimerDevice ioState
	# (pid,ioState)		= IOStGetIOId ioState
	  tHs				= TimerSystemStateGetTimerHandles timers
	  tsHs				= tHs.tTimers
	  rt				= StateMap2 disposeReceiverTableEntries` tsHs rt
	  tt				= StateMap2 (disposeTimerTableEntries` pid) tsHs tt
	# ioState			= IOStSetReceiverTable rt ioState
	# ioState			= IOStSetTimerTable tt ioState
	# ioState			= IOStRemoveDevice TimerDevice ioState
	= ioState
where
	disposeReceiverTableEntries` :: !(TimerStateHandle .ps) !ReceiverTable -> ReceiverTable
	disposeReceiverTableEntries` (TimerLSHandle {tHandle={tItems}}) rt
		= StateMap2 disposeReceiverTableEntries tItems rt
	
	disposeTimerTableEntries` :: !SystemId !(TimerStateHandle .ps) !TimerTable -> TimerTable
	disposeTimerTableEntries` pid (TimerLSHandle {tHandle={tItems}}) tt
		= StateMap2 (disposeTimerTableEntries pid) tItems tt


/*	PA: The following changes have been made to the timerIO function:
	-	type has been changed: !SleepTime --> OSSleepTime
	-	the timer handles the events that are filtered by timerEvent.
*/
timerIO	:: OSSleepTime !(DeviceEvent i o) !(PSt .l .p) -> (OSSleepTime,!DeviceEvent i o,!PSt .l .p)
timerIO sleepTime deviceEvent=:(TimerEvent te=:{teLoc={tlParentId,tlTimerId},teNrInterval}) pState=:{io}
	# (timer,ioState)	= IOStGetDevice TimerDevice io
	  timers			= TimerSystemStateGetTimerHandles timer
	  pState			= {pState & io=ioState}
	# pState			= letOneTimerDoIO tlParentId tlTimerId teNrInterval timers pState
	= (sleepTime,deviceEvent,pState)
where
	letOneTimerDoIO :: !Id !Id !NrOfIntervals !(TimerHandles (PSt .l .p)) !(PSt .l .p) -> PSt .l .p
	letOneTimerDoIO parent timer nrOfIntervals timers=:{tSysIds=ids,tTimers=tHs} pState
		= pState2
	where
		(_,tH,tHs1)		= URemove (identifyTimerStateHandle parent) (timerdeviceFatalError "timerIO _ (TimerEvent _)" "timer could not be found") tHs
		pState1			= appPIO (IOStSetDevice timers1) pState
		(tH1,pState2)	= letTimerDoIO nrOfIntervals tH pState1
		timers1			= TimerSystemState {timers & tSysIds=ids,tTimers=tHs1++[tH1]}
		
		letTimerDoIO :: !NrOfIntervals !(TimerStateHandle .ps) .ps -> (!TimerStateHandle .ps, .ps)
		letTimerDoIO nrOfIntervals (TimerLSHandle tsH=:{tState=ls,tHandle=tH=:{tFun}}) pState
			= (TimerLSHandle {tsH & tState=ls1},pState1)
		where
			(ls1,pState1)	= tFun nrOfIntervals (ls,pState)
timerIO sleepTime deviceEvent=:(ReceiverEvent (QASyncMessage event)) pState
	= (sleepTime,deviceEvent,timerQASync event pState)
where
	timerQASync :: !(QASyncMessage i) !(PSt .l .p) -> PSt .l .p
	timerQASync msg=:{qasmRecLoc={rlReceiverId=rid}} pState
		# (timer,ioState)	= IOStGetDevice TimerDevice pState.io
		  timers			= TimerSystemStateGetTimerHandles timer
		  tsHs				= handleASyncReceiver rid msg timers.tTimers
		  timers			= {timers & tTimers=tsHs}
		# ioState			= IOStSetDevice (TimerSystemState timers) ioState
		# pState			= {pState & io=ioState}
		= pState
	where
		handleASyncReceiver :: !Id !(QASyncMessage i) ![TimerStateHandle .ps] -> [TimerStateHandle .ps]
		handleASyncReceiver rid msg [TimerLSHandle tlsH=:{tHandle=tH=:{tItems}}:tsHs]
			# (done,tItems)	= qMessage rid msg tItems
			  tsH			= TimerLSHandle {tlsH & tHandle={tH & tItems=tItems}}
			| done
			= [tsH:tsHs]
			= [tsH:handleASyncReceiver rid msg tsHs]
		where
			qMessage :: !Id !(QASyncMessage i) ![TimerElementHandle .ls .ps] -> (!Bool,![TimerElementHandle .ls .ps])
			qMessage rid msg [itemH:itemHs]
				# (done,itemH)	= qMessage` rid msg itemH
				| done
				= (done,[itemH:itemHs])
				# (done,itemHs)	= qMessage rid msg itemHs
				= (done,[itemH:itemHs])
			where
				qMessage` :: !Id !(QASyncMessage i) !(TimerElementHandle .ls .ps) -> (!Bool,!TimerElementHandle .ls .ps)
				qMessage` rid {qasmMsg} (TimerReceiverHandle trH=:{tReceiverHandle=rH})
					| receiverIdentified rid rH
					= (True, TimerReceiverHandle {trH & tReceiverHandle=receiverAddASyncMessage rid qasmMsg rH})
					= (False,TimerReceiverHandle trH)
				qMessage` rid msg (TimerListLSHandle itemHs)
					# (done,itemHs) = qMessage rid msg itemHs
					= (done,TimerListLSHandle itemHs)
				qMessage` rid msg (TimerElimLSHandle itemHs)
					# (done,itemHs) = qMessage rid msg itemHs
					= (done,TimerElimLSHandle itemHs)
				qMessage` rid msg (TimerIntroLSHandle tInH=:{tIntroItems})
					# (done,itemHs) = qMessage rid msg tIntroItems
					= (done,TimerIntroLSHandle {tInH & tIntroItems=itemHs})
				qMessage` rid msg (TimerExtendLSHandle tExH=:{tExtendItems})
					# (done,itemHs) = qMessage rid msg tExtendItems
					= (done,TimerExtendLSHandle {tExH & tExtendItems=itemHs})
				qMessage` rid msg (TimerChangeLSHandle tChH=:{tChangeItems})
					# (done,itemHs) = qMessage rid msg tChangeItems
					= (done,TimerChangeLSHandle {tChH & tChangeItems=itemHs})
			qMessage _ _ _
				= (False,[])
		handleASyncReceiver _ _ _
			= []
timerIO sleepTime deviceEvent=:(ReceiverEvent (ASyncMessage event)) pState
	= (sleepTime,deviceEvent,timerASync event pState)
where
	timerASync :: !ASyncMessage !(PSt .l .p) -> PSt .l .p
	timerASync {asmRecLoc={rlReceiverId=rid}} pState
		= pState2
	where
		(timers,ioState)= IOStGetDevice TimerDevice pState.io
		tHs				= TimerSystemStateGetTimerHandles timers
		(tsHs,pState2)	= aSyncTimerStateHandles rid tHs.tTimers pState1
		tHs1			= {tHs & tTimers=tsHs}
		ioState1		= IOStSetDevice (TimerSystemState tHs1) ioState
		pState1			= {pState & io=ioState1}
		
		aSyncTimerStateHandles :: !Id ![TimerStateHandle .ps] .ps -> (![TimerStateHandle .ps],.ps)
		aSyncTimerStateHandles rid [TimerLSHandle {tState=ls,tHandle=tH=:{tItems}}:tsHs] ps
			# (done,tItems,(ls,ps))	= aSyncTimerElementHandles rid tItems (ls,ps)
			  tsH					= TimerLSHandle {tState=ls,tHandle={tH & tItems=tItems}}
			| done
			= ([tsH:tsHs],ps)
			# (tsHs,ps)				= aSyncTimerStateHandles rid tsHs ps
			= ([tsH:tsHs],ps)
		where
			aSyncTimerElementHandles :: !Id ![TimerElementHandle .ls .ps] (.ls,.ps)
								  -> (!Bool,![TimerElementHandle .ls .ps],(.ls,.ps))
			aSyncTimerElementHandles rid [itemH:itemHs] ps
				# (done,itemH, ps)	= aSyncTimerElementHandle  rid itemH  ps
				| done
				= (done,[itemH:itemHs],ps)
				# (done,itemHs,ps)	= aSyncTimerElementHandles rid itemHs ps
				= (done,[itemH:itemHs],ps)
			where
				aSyncTimerElementHandle :: !Id !(TimerElementHandle .ls .ps) (.ls,.ps)
									  -> (!Bool,!TimerElementHandle .ls .ps, (.ls,.ps))
				aSyncTimerElementHandle rid (TimerListLSHandle itemHs) ps
					# (done,itemHs,ps) = aSyncTimerElementHandles rid itemHs ps
					= (done,TimerListLSHandle itemHs,ps)
				aSyncTimerElementHandle rid (TimerElimLSHandle itemHs) ps
					# (done,itemHs,ps) = aSyncTimerElementHandles rid itemHs ps
					= (done,TimerElimLSHandle itemHs,ps)
				aSyncTimerElementHandle rid (TimerIntroLSHandle {tIntroLS,tIntroItems}) (ls,ps)
					# (done,itemHs,(introLS,ps)) = aSyncTimerElementHandles rid tIntroItems (tIntroLS,ps)
					= (done,TimerIntroLSHandle {tIntroLS=introLS,tIntroItems=itemHs},(ls,ps))
				aSyncTimerElementHandle rid (TimerExtendLSHandle {tExtendLS,tExtendItems}) (ls,ps)
					# (done,itemHs,((extendLS,ls),ps)) = aSyncTimerElementHandles rid tExtendItems ((tExtendLS,ls),ps)
					= (done,TimerExtendLSHandle {tExtendLS=extendLS,tExtendItems=itemHs},(ls,ps))
				aSyncTimerElementHandle rid (TimerChangeLSHandle {tChangeLS,tChangeItems}) (ls,ps)
					# (done,itemHs,(changeLS,ps)) = aSyncTimerElementHandles rid tChangeItems (tChangeLS,ps)
					= (done,TimerChangeLSHandle {tChangeLS=changeLS,tChangeItems=itemHs},(ls,ps))
				aSyncTimerElementHandle rid itemH=:(TimerReceiverHandle trH=:{tReceiverHandle=rH}) (ls,ps)
					| receiverIdentified rid rH
					= (True, TimerReceiverHandle trH1,(ls1,ps1))
					= (False,TimerReceiverHandle trH, (ls, ps ))
				where
					(rH1,(ls1,ps1))		= aSyncReceiverHandle rH (ls,ps)
					trH1				= {trH & tReceiverHandle=rH1}
					
					aSyncReceiverHandle :: !(ReceiverHandle .ls .ps) (.ls,.ps) -> (!ReceiverHandle .ls .ps,(.ls,.ps))
					aSyncReceiverHandle rH=:{rFun,rASMQ=[m:tailQ]} (ls,ps)
						# (ls,_,ps)	= rFun m (ls,ps)
						= ({rH & rASMQ=tailQ},(ls,ps))
					aSyncReceiverHandle _ _
						= timerdeviceFatalError "asyncReceiverHandle" "message queue of target receiver is empty"
			aSyncTimerElementHandles _ _ ps
				= (False,[],ps)
		aSyncTimerStateHandles _ _ ps
			= ([],ps)
timerIO sleepTime (ReceiverEvent (SyncMessage event)) pState
	# (event,pState)	= timerSync event pState
	= (sleepTime,ReceiverEvent (SyncMessage event),pState)
where
	timerSync :: !(SyncMessage i o) !(PSt .l .p) -> (!SyncMessage i o,!PSt .l .p)
	timerSync msg=:{smRecLoc={rlReceiverId=rid}} pState
		= (msg1,pState2)
	where
		(timers,ioState)	= IOStGetDevice TimerDevice pState.io
		tHs					= TimerSystemStateGetTimerHandles timers
		(msg1,tsHs,pState2)	= syncTimerStateHandles rid msg tHs.tTimers pState1
		tHs1				= {tHs & tTimers=tsHs}
		ioState1			= IOStSetDevice (TimerSystemState tHs1) ioState
		pState1				= {pState & io=ioState1}
		
		syncTimerStateHandles :: !Id !(SyncMessage i o) ![TimerStateHandle .ps] .ps
								  -> (!SyncMessage i o, ![TimerStateHandle .ps],.ps)
		syncTimerStateHandles rid msg [TimerLSHandle {tState=ls,tHandle=tH=:{tItems}}:tsHs] ps
			# (done,msg,tItems,(ls,ps))	= syncTimerElementHandles rid msg tItems (ls,ps)
			  tsH						= TimerLSHandle {tState=ls,tHandle={tH & tItems=tItems}}
			| done
			= (msg,[tsH:tsHs],ps)
			# (msg,tsHs,ps)				= syncTimerStateHandles rid msg tsHs ps
			= (msg,[tsH:tsHs],ps)
		where
			syncTimerElementHandles :: !Id !(SyncMessage i o) ![TimerElementHandle .ls .ps] (.ls,.ps)
								  -> (!Bool,!SyncMessage i o, ![TimerElementHandle .ls .ps],(.ls,.ps))
			syncTimerElementHandles rid msg [itemH:itemHs] (ls,ps)
				# (done,msg,itemH,(ls,ps))	= syncTimerElementHandle rid msg itemH (ls,ps)
				| done
				= (done,msg,[itemH:itemHs],(ls,ps))
				# (done,msg,itemHs,(ls,ps))	= syncTimerElementHandles rid msg itemHs (ls,ps)
				= (done,msg,[itemH:itemHs],(ls,ps))
			where
				syncTimerElementHandle :: !Id !(SyncMessage i o) !(TimerElementHandle .ls .ps) (.ls,.ps)
									 -> (!Bool,!SyncMessage i o,  !TimerElementHandle .ls .ps, (.ls,.ps))
				syncTimerElementHandle rid msg (TimerReceiverHandle trH=:{tReceiverHandle=rH}) (ls,ps)
					| not (receiverIdentified rid rH)
					= (False,msg,TimerReceiverHandle trH,(ls,ps))
					# (resp,rH,(ls,ps))	= receiverHandleSyncMessage msg rH (ls,ps)
					= (True, {msg & smResp=resp},TimerReceiverHandle {trH & tReceiverHandle=rH},(ls,ps))
				syncTimerElementHandle rid msg (TimerListLSHandle itemHs) (ls,ps)
					# (done,msg,itemHs,(ls,ps))	= syncTimerElementHandles rid msg itemHs (ls,ps)
					= (done,msg,TimerListLSHandle itemHs,(ls,ps))
				syncTimerElementHandle rid msg (TimerElimLSHandle itemHs) (ls,ps)
					# (done,msg,itemHs,(ls,ps))	= syncTimerElementHandles rid msg itemHs (ls,ps)
					= (done,msg,TimerElimLSHandle itemHs,(ls,ps))
				syncTimerElementHandle rid msg (TimerIntroLSHandle {tIntroLS=inLS,tIntroItems}) (ls,ps)
					# (done,msg,itemHs,(inLS,ps))	= syncTimerElementHandles rid msg tIntroItems (inLS,ps)
					= (done,msg,TimerIntroLSHandle {tIntroLS=inLS,tIntroItems=itemHs},(ls,ps))
				syncTimerElementHandle rid msg (TimerExtendLSHandle {tExtendLS,tExtendItems}) (ls,ps)
					# (done,msg,itemHs,((exLS,ls),ps))	= syncTimerElementHandles rid msg tExtendItems ((tExtendLS,ls),ps)
					= (done,msg,TimerExtendLSHandle {tExtendLS=exLS,tExtendItems=itemHs},(ls,ps))
				syncTimerElementHandle rid msg (TimerChangeLSHandle {tChangeLS,tChangeItems}) (ls,ps)
					# (done,msg,itemHs,(chLS,ps))	= syncTimerElementHandles rid msg tChangeItems (tChangeLS,ps)
					= (done,msg,TimerChangeLSHandle {tChangeLS=chLS,tChangeItems=itemHs},(ls,ps))
			syncTimerElementHandles _ msg _ (ls,ps)
				= (False,msg,[],(ls,ps))
		syncTimerStateHandles _ msg _ ps
			= (msg,[],ps)
timerIO _ _ _
	= timerdeviceFatalError "timerIO" "device event passed timer event filter without handling"
